/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2003 - 2010                         */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.C:  Flash Programming Functions adapted                   */
/*               for ES32F3xx external NAND Flash                      */
/*                                                                     */
/***********************************************************************/

/* ES32F36xx external flash (NAND Flash) based address */
/* originally included this parameter from ES32 SDK header file. */


/* Specified for FlashDev.c and FlashPrg.c */
#define FLASH_BASE_ADDR 	(0x64000000)//(0x70000000)	/* nand flash address in ext mem */
#define FLASH_SIZE			(0x8400000)		/* 132MB */
#define FLASH_PAGE_SIZE		(0x840)			/* 2112B */
#define FLASH_SECTORE_SIZE	(0x21000)		/* 132KB */

/* Specified detailed information for nand.c and FlashPrg.c */
#define NAND_PAGE_SIZE        0x800  /* 2048 bytes per page ignore Spare Area */
#define NAND_BLOCK_SIZE       0x040  /* 64 pages per block */
#define NAND_PLANE_SIZE       0x400  /* 1024 Block per plane */
#define NAND_SPARE_AREA_SIZE  0x040  /* last 64 bytes as spare area */
#define NAND_BLOCK_NBR        0x400  /* 1 planes of 1024 block */
#define NAND_PLANE_NBR        1       /* 1 device of 1 planes */
#define BUFFER_SIZE           0x800   /* (NAND_PAGE_SIZE * NAND_PLANE_NBR) */

